/*
 * Decompiled with CFR 0.152.
 */
package lumien.resourceloader.loader;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import lumien.resourceloader.ResourceLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.logging.log4j.Level;

public class NormalResourceLoader
implements IResourcePack {
    boolean debug = false;

    public InputStream func_110590_a(ResourceLocation rl) throws IOException {
        if (!this.func_110589_b(rl)) {
            return null;
        }
        File file = new File(new File(Minecraft.func_71410_x().field_71412_D, "resources/" + rl.func_110624_b()), rl.func_110623_a());
        String realFileName = file.getCanonicalFile().getName();
        if (!realFileName.equals(file.getName())) {
            ResourceLoader.logger.log(Level.WARN, "[NormalResourceLoader] Resource Location " + rl.toString() + " only matches the file " + realFileName + " because RL is running in an environment that isn't case sensitive in regards to file names. This will not work properly on for example Linux.");
        }
        return new FileInputStream(file);
    }

    public boolean func_110589_b(ResourceLocation rl) {
        File fileRequested = new File(new File(Minecraft.func_71410_x().field_71412_D, "resources/" + rl.func_110624_b()), rl.func_110623_a());
        if (this.debug && !fileRequested.isFile()) {
            ResourceLoader.logger.log(Level.DEBUG, "[NormalResourceLoader] Asked for resource " + rl.toString() + " but can't find a file at " + fileRequested.getAbsolutePath());
        }
        return fileRequested.isFile();
    }

    public Set func_110587_b() {
        File[] resourceDomains;
        File folder = new File(Minecraft.func_71410_x().field_71412_D, "resources");
        if (!folder.exists()) {
            folder.mkdir();
        }
        HashSet<String> folders = new HashSet<String>();
        ResourceLoader.logger.log(Level.DEBUG, "[NormalResourceLoader] Resource Loader Domains: ");
        for (File resourceFolder : resourceDomains = folder.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY)) {
            if (!resourceFolder.getName().equals("debug")) continue;
            this.debug = true;
        }
        for (File resourceFolder : resourceDomains) {
            ResourceLoader.logger.log(Level.DEBUG, "[NormalResourceLoader]  - " + resourceFolder.getName() + " | " + resourceFolder.getAbsolutePath());
            folders.add(resourceFolder.getName());
        }
        return folders;
    }

    public IMetadataSection func_135058_a(MetadataSerializer p_135058_1_, String p_135058_2_) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    public String func_130077_b() {
        return "CustomResources";
    }
}

