/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.client.toast;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraftforge.client.event.MouseEvent;

public class Toast {
    private final int xPos;
    private final int yPos;
    private final int width;
    private final int height;
    private final List<String> message;
    boolean mouseOver;
    int time;

    public Toast(int xPos, int yPos, int width, int time, String ... message) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.width = width;
        this.time = time;
        this.message = Arrays.asList(message);
        this.height = this.message.size() * Minecraft.func_71410_x().field_71466_p.field_78288_b + 7;
    }

    public void onMouseEvent(MouseEvent mouseEvent) {
    }

    public void drawToast(int mouseX, int mouseY) {
        if (this.time > 0) {
            int opacity;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            this.mouseOver = mouseX >= this.xPos && mouseY >= this.yPos && mouseX < this.xPos + this.width && mouseY < this.yPos + this.height;
            int n = opacity = this.mouseOver ? 255 : (int)((float)this.time * 256.0f / 10.0f);
            if (opacity > 255) {
                opacity = 255;
            }
            if (this.mouseOver) {
                this.time = 20;
            }
            if (opacity > 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_179140_f();
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                this.drawBackdrop(this.xPos, this.yPos, this.width, this.height);
                int colour = 0xFFFFFF | opacity << 24;
                for (int i = 0; i < this.message.size(); ++i) {
                    String s = this.message.get(i);
                    fontRenderer.func_175063_a(s, (float)(this.xPos + this.width / 2 - fontRenderer.func_78256_a(s) / 2), (float)(this.yPos + 4 + fontRenderer.field_78288_b * i), colour);
                }
                GlStateManager.func_179084_k();
                GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            }
        }
    }

    private void drawBackdrop(int x, int y, int width, int height) {
        int opacity;
        int n = opacity = this.mouseOver ? 255 : (int)((float)this.time * 256.0f / 25.0f);
        if (opacity > 255) {
            opacity = 255;
        }
        int colour = opacity << 24;
        Gui.func_73734_a((int)(x + 1), (int)y, (int)(x + width - 1), (int)(y + height), (int)colour);
        Gui.func_73734_a((int)x, (int)(y + 1), (int)(x + 1), (int)(y + height - 1), (int)colour);
        Gui.func_73734_a((int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height - 1), (int)colour);
        colour = 0x28025C | opacity << 24;
        Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + 2), (int)colour);
        Gui.func_73734_a((int)(x + 1), (int)(y + height - 1), (int)(x + width - 1), (int)(y + height - 2), (int)colour);
        Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + 2), (int)(y + height - 1), (int)colour);
        Gui.func_73734_a((int)(x + width - 1), (int)(y + 1), (int)(x + width - 2), (int)(y + height - 1), (int)colour);
    }
}

