/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.common.network;

import com.google.common.base.Strings;
import com.google.gson.JsonSyntaxException;
import com.mojang.util.UUIDTypeAdapter;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import uk.kihira.tails.common.PartsData;
import uk.kihira.tails.common.Tails;

public class PlayerDataMessage
implements IMessage {
    private UUID uuid;
    private PartsData partsData;
    private boolean shouldRemove;

    public PlayerDataMessage() {
    }

    public PlayerDataMessage(UUID uuid, PartsData partsData, boolean shouldRemove) {
        this.uuid = uuid;
        this.partsData = partsData;
        this.shouldRemove = shouldRemove;
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid = UUIDTypeAdapter.fromString((String)ByteBufUtils.readUTF8String((ByteBuf)buf));
        String tailInfoJson = ByteBufUtils.readUTF8String((ByteBuf)buf);
        if (!Strings.isNullOrEmpty((String)tailInfoJson)) {
            try {
                this.partsData = (PartsData)Tails.gson.fromJson(tailInfoJson, PartsData.class);
            }
            catch (JsonSyntaxException e) {
                Tails.logger.warn((Object)e);
            }
        } else {
            this.partsData = null;
        }
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)UUIDTypeAdapter.fromUUID((UUID)this.uuid));
        String tailInfoJson = this.partsData == null ? "" : Tails.gson.toJson((Object)this.partsData);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)tailInfoJson);
    }

    public static class Handler
    implements IMessageHandler<PlayerDataMessage, IMessage> {
        public IMessage onMessage(PlayerDataMessage message, MessageContext ctx) {
            if (message.shouldRemove) {
                Tails.proxy.removePartsData(message.uuid);
            } else if (message.partsData != null) {
                Tails.proxy.addPartsData(message.uuid, message.partsData);
                if (ctx.side.isServer()) {
                    Tails.networkWrapper.sendToAll((IMessage)new PlayerDataMessage(message.uuid, message.partsData, false));
                }
            }
            return null;
        }
    }
}

