/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc.integration.computercraft;

import dan200.computercraft.api.lua.ILuaObject;
import java.util.Map;
import li.cil.oc.api.driver.Converter;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedPeripheral;
import li.cil.oc.api.prefab.AbstractValue;
import li.cil.oc.integration.computercraft.CallableHelper;
import li.cil.oc.integration.computercraft.DriverPeripheral;

public final class ConverterLuaObject
implements Converter {
    @Override
    public void convert(Object value, Map<Object, Object> output) {
        if (value instanceof ILuaObject) {
            output.put("value", new LuaObjectValue((ILuaObject)value));
        }
    }

    public static final class LuaObjectValue
    extends AbstractValue
    implements ManagedPeripheral {
        private final ILuaObject value;
        protected final CallableHelper helper;

        public LuaObjectValue() {
            this.value = null;
            this.helper = null;
        }

        public LuaObjectValue(ILuaObject value) {
            this.value = value;
            this.helper = new CallableHelper(value.getMethodNames());
        }

        @Override
        public String[] methods() {
            if (this.value != null) {
                return this.value.getMethodNames();
            }
            return new String[0];
        }

        @Override
        public Object[] invoke(String method, Context context, Arguments args) throws Exception {
            if (this.value != null) {
                int index = this.helper.methodIndex(method);
                Object[] argArray = this.helper.convertArguments(args);
                return this.value.callMethod(DriverPeripheral.Environment.UnsupportedLuaContext.instance(), index, argArray);
            }
            return new Object[]{null, "ComputerCraft userdata cannot be persisted"};
        }
    }
}

