/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod.client.gui;

import java.awt.Color;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import superhb.arcademod.api.gui.GuiArcade;
import superhb.arcademod.client.ArcadeItems;
import superhb.arcademod.client.tileentity.TileEntityArcade;
import superhb.arcademod.util.KeyHandler;

public class GuiTetrominoes
extends GuiArcade {
    private static final ResourceLocation texture = new ResourceLocation("arcademod:textures/gui/tetrominoes.png");
    private static final int GUI_X = 210;
    private static final int GUI_Y = 254;
    private static final int PLAY_BLOCK = 13;
    private static final int PREVIEW_BLOCK = 11;
    private static final int ARROW_VERTICAL_X = 11;
    private static final int ARROW_VERTICAL_Y = 7;
    private static final int ARROW_HORIZONTAL_X = 7;
    private static final int ARROW_HORIZONTAL_Y = 11;
    private boolean playMusic = true;
    private int score = 0;
    private int row = 0;
    private int level = 1;
    private boolean gameOver = false;
    private int rotation = 0;
    private int playX;
    private int playY;
    private int nextX;
    private int nextY;
    private int nextShape = 0;
    private int curShape;
    private boolean giveNextPiece = true;
    private Point piecePoint = new Point(3, 0);
    private int[][] board;
    private int[] speed = new int[]{1, 10, 10, 9, 8, 7, 6, 5, 4, 3, 2};
    private int prevControlTick = 0;
    private int controlSpeed = 2;
    private int prevGameTick = 0;
    private final Point[][][] pieces = new Point[][][]{{{new Point(0, 1), new Point(1, 1), new Point(2, 1), new Point(3, 1)}, {new Point(1, 0), new Point(1, 1), new Point(1, 2), new Point(1, 3)}, {new Point(0, 1), new Point(1, 1), new Point(2, 1), new Point(3, 1)}, {new Point(1, 0), new Point(1, 1), new Point(1, 2), new Point(1, 3)}}, {{new Point(0, 1), new Point(1, 1), new Point(2, 1), new Point(2, 2)}, {new Point(1, 0), new Point(1, 1), new Point(1, 2), new Point(0, 2)}, {new Point(0, 1), new Point(1, 1), new Point(2, 1), new Point(0, 0)}, {new Point(1, 0), new Point(1, 1), new Point(1, 2), new Point(2, 0)}}, {{new Point(0, 1), new Point(1, 1), new Point(2, 1), new Point(0, 2)}, {new Point(1, 0), new Point(1, 1), new Point(1, 2), new Point(0, 0)}, {new Point(0, 1), new Point(1, 1), new Point(2, 1), new Point(2, 0)}, {new Point(1, 0), new Point(1, 1), new Point(1, 2), new Point(2, 2)}}, {{new Point(1, 1), new Point(2, 1), new Point(0, 2), new Point(1, 2)}, {new Point(0, 1), new Point(0, 2), new Point(1, 2), new Point(1, 3)}, {new Point(1, 1), new Point(2, 1), new Point(0, 2), new Point(1, 2)}, {new Point(0, 1), new Point(0, 2), new Point(1, 2), new Point(1, 3)}}, {{new Point(0, 1), new Point(1, 1), new Point(1, 2), new Point(2, 2)}, {new Point(1, 1), new Point(0, 2), new Point(1, 2), new Point(0, 3)}, {new Point(0, 1), new Point(1, 1), new Point(1, 2), new Point(2, 2)}, {new Point(1, 1), new Point(0, 2), new Point(1, 2), new Point(0, 3)}}, {{new Point(0, 1), new Point(0, 2), new Point(1, 1), new Point(1, 2)}, {new Point(0, 1), new Point(0, 2), new Point(1, 1), new Point(1, 2)}, {new Point(0, 1), new Point(0, 2), new Point(1, 1), new Point(1, 2)}, {new Point(0, 1), new Point(0, 2), new Point(1, 1), new Point(1, 2)}}, {{new Point(0, 1), new Point(1, 1), new Point(2, 1), new Point(1, 2)}, {new Point(1, 0), new Point(1, 1), new Point(2, 1), new Point(1, 2)}, {new Point(1, 0), new Point(0, 1), new Point(1, 1), new Point(2, 1)}, {new Point(1, 0), new Point(0, 1), new Point(1, 1), new Point(1, 2)}}};
    private final Color[] colors = new Color[]{Color.cyan, Color.blue, new Color(1.0f, 0.549f, 0.0f), Color.GREEN, Color.RED, Color.yellow, new Color(1.0f, 0.078f, 0.576f)};

    public GuiTetrominoes(World world, TileEntityArcade tileEntity, EntityPlayer player) {
        super(world, tileEntity, null, player);
        this.setGuiSize(210, 254, 0.9f);
        this.setTexture(texture);
        this.setOffset(-30, 0);
        this.setButtonPos(105 - this.buttonWidth / 2 - 30, 222);
        this.setStartMenu(0);
        this.setCost(2);
        this.nextShape = this.getWorld().field_73012_v.nextInt(7);
        this.board = new int[10][18];
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 18; ++y) {
                this.board[x][y] = -1;
            }
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.inMenu) {
            if (this.menu == 3 && this.tickCounter >= 60) {
                this.tickCounter = 0;
                this.checkMenuAfterGameOver();
                this.nextShape = this.getWorld().field_73012_v.nextInt(7);
                this.score = 0;
                this.row = 0;
                this.level = 1;
                this.rotation = 0;
                for (int x = 0; x < 10; ++x) {
                    for (int y = 0; y < 18; ++y) {
                        this.board[x][y] = -1;
                    }
                }
            }
        } else {
            if (this.gameOver) {
                this.menu = 3;
                this.giveNextPiece = false;
                this.inMenu = true;
                this.gameOver = false;
                this.giveReward(ArcadeItems.TICKET, this.row);
            }
            if (this.giveNextPiece) {
                this.rotation = 0;
                this.curShape = this.nextShape;
                this.nextShape = this.getWorld().field_73012_v.nextInt(7);
                this.piecePoint = new Point(3, 0);
                this.giveNextPiece = false;
            }
            if (this.tickCounter - this.prevGameTick >= (this.isKeyDown(KeyHandler.down.func_151463_i()) ? this.speed[0] : this.speed[this.level])) {
                this.prevGameTick = this.tickCounter;
                if (this.canMoveDown()) {
                    ++this.piecePoint.y;
                } else {
                    this.place();
                }
            }
            if (this.tickCounter - this.prevControlTick >= this.controlSpeed) {
                this.prevControlTick = this.tickCounter;
                if (this.isKeyDown(KeyHandler.left.func_151463_i())) {
                    if (this.canMoveLeft()) {
                        --this.piecePoint.x;
                    }
                } else if (this.isKeyDown(KeyHandler.right.func_151463_i()) && this.canMoveRight()) {
                    ++this.piecePoint.x;
                }
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.playX = this.xScaled - 105 + 10;
        this.playY = this.yScaled - 127 + 10;
        this.nextX = this.playX + 140;
        this.nextY = this.playY + 8;
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int controlWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:control.locale", (Object[])new Object[0]));
        if (this.inMenu) {
            switch (this.menu) {
                case 0: {
                    int titleWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"game.arcademod:tetrominoes.name", (Object[])new Object[0]));
                    int startWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"option.arcademod:start.locale", (Object[])new Object[0]));
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"game.arcademod:tetrominoes.name", (Object[])new Object[0]), this.playX + 65 - titleWidth / 2, this.playY + 2, Color.white.getRGB());
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:start.locale", (Object[])new Object[0]), this.playX + 65 - startWidth / 2, this.field_146295_m / 2, Color.white.getRGB());
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:control.locale", (Object[])new Object[0]), this.playX + 65 - controlWidth / 2, this.field_146295_m / 2 + 10, Color.white.getRGB());
                    if (this.menuOption == 0) {
                        this.drawRightArrow(this.playX + 65 - 40, this.field_146295_m / 2 - 2, true);
                        break;
                    }
                    if (this.menuOption != 1) break;
                    this.drawRightArrow(this.playX + 65 - 40, this.field_146295_m / 2 + 8, true);
                    break;
                }
                case 1: {
                    int levelWidth = this.field_146289_q.func_78256_a(String.format("[%d]", this.level));
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:level_select.tetrominoes.locale", (Object[])new Object[0]), this.playX + 65 - 40, this.yScaled, Color.white.getRGB());
                    this.field_146289_q.func_78276_b(String.format("[%d]", this.level), this.playX + 65 + 35 - levelWidth / 2, this.yScaled, Color.white.getRGB());
                    this.drawUpArrow(this.playX + 65 + 29, this.yScaled - 10, true);
                    this.drawDownArrow(this.playX + 65 + 29, this.yScaled + 10);
                    this.field_146289_q.func_78276_b("[" + KeyHandler.left.getDisplayName() + "] " + I18n.func_135052_a((String)"option.arcademod:back.name", (Object[])new Object[0]), this.playX + 2, this.yScaled + 127 - 20, Color.white.getRGB());
                    break;
                }
                case 2: {
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"option.arcademod:control.locale", (Object[])new Object[0]), this.playX + 65 - controlWidth / 2, this.playY + 2, Color.white.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.up.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:up.tetrominoes.name", (Object[])new Object[0]), this.playX + 65 - 40, this.yScaled - 10, Color.white.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.down.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:down.name", (Object[])new Object[0]), this.playX + 65 - 40, this.yScaled, Color.white.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.left.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:left.name", (Object[])new Object[0]), this.playX + 65 - 40, this.yScaled + 10, Color.white.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.right.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:right.name", (Object[])new Object[0]), this.playX + 65 - 40, this.yScaled + 20, Color.white.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.select.getDisplayName() + "] " + I18n.func_135052_a((String)"control.arcademod:select.name", (Object[])new Object[0]), this.playX + 65 - 40, this.yScaled + 30, Color.white.getRGB());
                    this.field_146289_q.func_78276_b("[" + KeyHandler.left.getDisplayName() + "] " + I18n.func_135052_a((String)"option.arcademod:back.name", (Object[])new Object[0]), this.playX + 2, this.yScaled + 127 - 20, Color.white.getRGB());
                    break;
                }
                case 3: {
                    int overWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"text.arcademod:gameover.locale", (Object[])new Object[0]));
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:gameover.locale", (Object[])new Object[0]), this.playX + 65 - overWidth / 2, this.yScaled - 20, Color.white.getRGB());
                    int scoreWidth = this.field_146289_q.func_78256_a(I18n.func_135052_a((String)"text.arcademod:score.locale", (Object[])new Object[0]) + ": " + this.score);
                    this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:score.locale", (Object[])new Object[0]) + ": " + this.score, this.playX + 65 - scoreWidth / 2, this.yScaled - 10, Color.white.getRGB());
                }
            }
        } else {
            this.drawTetromino(this.curShape, this.rotation, this.piecePoint.x, this.piecePoint.y);
            for (int x = 0; x < 10; ++x) {
                for (int y = 0; y < 18; ++y) {
                    if (this.board[x][y] == -1) continue;
                    this.drawBlock(this.board[x][y], x, y);
                }
            }
            this.drawPreview(this.nextShape);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"text.arcademod:next.tetrominoes.locale", (Object[])new Object[0]) + ":", this.xScaled + 105 - 60, this.playY, 0x404040);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"text.arcademod:level.tetrominoes.locale", (Object[])new Object[0]) + ": " + this.level, this.xScaled + 105 - 60, this.nextY + 38, 50, 0x404040);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"text.arcademod:row.tetrominoes.locale", (Object[])new Object[0]) + ": " + this.row, this.xScaled + 105 - 60, this.nextY + 63, 50, 0x404040);
            this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"text.arcademod:score.locale", (Object[])new Object[0]) + ": " + this.score, this.xScaled + 105 - 60, this.nextY + 88, 50, 0x404040);
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == KeyHandler.up.func_151463_i()) {
            if (this.inMenu) {
                if (this.menu == 0) {
                    this.menuOption = this.menuOption == 0 ? 1 : --this.menuOption;
                } else if (this.menu == 1 && this.level != 10) {
                    ++this.level;
                }
            } else if (this.canRotate()) {
                this.rotation = this.rotation == 3 ? 0 : ++this.rotation;
            }
        }
        if (keyCode == KeyHandler.down.func_151463_i() && this.inMenu) {
            if (this.menu == 0) {
                this.menuOption = this.menuOption == 1 ? 0 : ++this.menuOption;
            } else if (this.menu == 1 && this.level != 1) {
                --this.level;
            }
        }
        if (keyCode == KeyHandler.left.func_151463_i() && this.inMenu && (this.menu == 1 || this.menu == 2)) {
            this.menu = 0;
        }
        if (keyCode != KeyHandler.right.func_151463_i() || this.inMenu) {
            // empty if block
        }
        if (keyCode == KeyHandler.select.func_151463_i() && this.inMenu) {
            if (this.menu == 0) {
                switch (this.menuOption) {
                    case 0: {
                        this.menu = 1;
                        break;
                    }
                    case 1: {
                        this.menu = 2;
                    }
                }
            } else if (this.menu == 1) {
                this.inMenu = false;
                if (this.tickCounter - this.prevGameTick >= 1) {
                    this.prevGameTick = this.tickCounter;
                    this.canGetCoinBack = false;
                    this.giveNextPiece = true;
                }
            }
        }
        if (keyCode == 1 && !this.inMenu) {
            this.giveReward(ArcadeItems.TICKET, this.row);
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private void checkLevel() {
        if (this.row >= 10 && this.level == 1) {
            this.level = 2;
        } else if (this.row >= 20 && this.level == 2) {
            this.level = 3;
        } else if (this.row >= 30 && this.level == 3) {
            this.level = 4;
        } else if (this.row >= 40 && this.level == 4) {
            this.level = 5;
        } else if (this.row >= 50 && this.level == 5) {
            this.level = 6;
        } else if (this.row >= 60 && this.level == 6) {
            this.level = 7;
        } else if (this.row >= 70 && this.level == 7) {
            this.level = 8;
        } else if (this.row >= 80 && this.level == 8) {
            this.level = 9;
        } else if (this.row >= 90 && this.level == 9) {
            this.level = 10;
        }
    }

    private void drawTetromino(int shape, int rotation, int x, int y) {
        this.glColor(this.colors[shape]);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        for (int i = 0; i < 4; ++i) {
            this.func_73729_b(this.playX + x * 13 + this.pieces[shape][rotation][i].x * 13, this.playY + y * 13 + this.pieces[shape][rotation][i].y * 13 - 13, 210, 0, 13, 13);
        }
    }

    private void drawBlock(int shape, int x, int y) {
        this.glColor(this.colors[shape]);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        this.func_73729_b(this.playX + x * 13, this.playY + y * 13, 210, 0, 13, 13);
    }

    private void drawPreview(int shape) {
        int[][] pos = new int[][]{{3, -2}, {8, -8}, {8, -8}, {8, -8}, {8, -8}, {14, -8}, {8, -8}};
        this.glColor(this.colors[shape]);
        this.field_146297_k.func_110434_K().func_110577_a(texture);
        for (int i = 0; i < 4; ++i) {
            this.func_73729_b(this.nextX + pos[shape][0] + this.pieces[shape][0][i].x * 11, this.nextY + pos[shape][1] + this.pieces[shape][0][i].y * 11, 223, 0, 11, 11);
        }
    }

    private boolean canRotate() {
        int nextRot = 0;
        nextRot = this.rotation == 3 ? 0 : this.rotation + 1;
        if (this.piecePoint.y == 0 && (this.curShape < 3 || this.curShape == 6)) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.piecePoint.x + this.pieces[this.curShape][nextRot][i].x < 0 || this.piecePoint.x + this.pieces[this.curShape][nextRot][i].x > 9) {
                return false;
            }
            if (this.board[this.piecePoint.x + this.pieces[this.curShape][nextRot][i].x][this.piecePoint.y + this.pieces[this.curShape][nextRot][i].y - 1] == -1) continue;
            return false;
        }
        return true;
    }

    private boolean canMoveLeft() {
        for (int i = 0; i < 4; ++i) {
            if (this.piecePoint.x + this.pieces[this.curShape][this.rotation][i].x == 0) {
                return false;
            }
            if (this.board[this.piecePoint.x + this.pieces[this.curShape][this.rotation][i].x - 1][this.piecePoint.y + this.pieces[this.curShape][this.rotation][i].y - 1] == -1) continue;
            return false;
        }
        return true;
    }

    private boolean canMoveRight() {
        for (int i = 0; i < 4; ++i) {
            if (this.piecePoint.x + this.pieces[this.curShape][this.rotation][i].x == 9) {
                return false;
            }
            if (this.board[this.piecePoint.x + this.pieces[this.curShape][this.rotation][i].x + 1][this.piecePoint.y + this.pieces[this.curShape][this.rotation][i].y - 1] == -1) continue;
            return false;
        }
        return true;
    }

    private boolean canMoveDown() {
        for (int i = 0; i < 4; ++i) {
            if (this.piecePoint.y + this.pieces[this.curShape][this.rotation][i].y - 1 == 17) {
                return false;
            }
            if (this.board[this.piecePoint.x + this.pieces[this.curShape][this.rotation][i].x][this.piecePoint.y + this.pieces[this.curShape][this.rotation][i].y] == -1) continue;
            return false;
        }
        return true;
    }

    private void place() {
        for (int i = 0; i < 4; ++i) {
            this.board[this.piecePoint.x + this.pieces[this.curShape][this.rotation][i].x][this.piecePoint.y + this.pieces[this.curShape][this.rotation][i].y - 1] = this.curShape;
        }
        for (int x = 0; x < 10; ++x) {
            if (this.board[x][0] == -1) continue;
            this.gameOver = true;
            return;
        }
        this.score += 17;
        this.checkForRow();
        this.giveNextPiece = true;
    }

    private void checkForRow() {
        int y;
        ArrayList<int[]> boardList = new ArrayList<int[]>();
        for (int i = 0; i < 18; ++i) {
            boardList.add(i, new int[]{this.board[0][i], this.board[1][i], this.board[2][i], this.board[3][i], this.board[4][i], this.board[5][i], this.board[6][i], this.board[7][i], this.board[8][i], this.board[9][i]});
        }
        for (y = 0; y < 18; ++y) {
            if (this.board[0][y] == -1 || this.board[1][y] == -1 || this.board[2][y] == -1 || this.board[3][y] == -1 || this.board[4][y] == -1 || this.board[5][y] == -1 || this.board[6][y] == -1 || this.board[7][y] == -1 || this.board[8][y] == -1 || this.board[9][y] == -1) continue;
            ++this.row;
            this.checkLevel();
            this.score += 41;
            boardList.remove(y);
            boardList.add(0, new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1});
        }
        for (y = 0; y < 18; ++y) {
            int[] boardX = (int[])boardList.get(y);
            for (int x = 0; x < 10; ++x) {
                this.board[x][y] = boardX[x];
            }
        }
    }
}

