/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.print;

import com.mrcrayfish.device.api.print.PrintingManager;
import com.mrcrayfish.device.init.DeviceBlocks;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IPrint {
    public String getName();

    public int speed();

    public boolean requiresColor();

    public NBTTagCompound toTag();

    public void fromTag(NBTTagCompound var1);

    @SideOnly(value=Side.CLIENT)
    public Class<? extends Renderer> getRenderer();

    public static NBTTagCompound writeToTag(IPrint print) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("type", PrintingManager.getPrintIdentifier(print));
        tag.func_74782_a("data", (NBTBase)print.toTag());
        return tag;
    }

    @Nullable
    public static IPrint loadFromTag(NBTTagCompound tag) {
        IPrint print = PrintingManager.getPrint(tag.func_74779_i("type"));
        if (print != null) {
            print.fromTag(tag.func_74775_l("data"));
            return print;
        }
        return null;
    }

    public static ItemStack generateItem(IPrint print) {
        NBTTagCompound blockEntityTag = new NBTTagCompound();
        blockEntityTag.func_74782_a("print", (NBTBase)IPrint.writeToTag(print));
        NBTTagCompound itemTag = new NBTTagCompound();
        itemTag.func_74782_a("BlockEntityTag", (NBTBase)blockEntityTag);
        ItemStack stack = new ItemStack(DeviceBlocks.PAPER);
        stack.func_77982_d(itemTag);
        if (print.getName() != null && !print.getName().isEmpty()) {
            stack.func_151001_c(print.getName());
        }
        return stack;
    }

    public static interface Renderer {
        public boolean render(NBTTagCompound var1);
    }
}

