/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core;

import com.mrcrayfish.device.api.app.Dialog;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.core.Window;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;

public abstract class Wrappable {
    private Window window;

    public abstract void init(@Nullable NBTTagCompound var1);

    public abstract void onTick();

    public abstract void render(Laptop var1, Minecraft var2, int var3, int var4, int var5, int var6, boolean var7, float var8);

    public abstract void handleKeyTyped(char var1, int var2);

    public abstract void handleKeyReleased(char var1, int var2);

    public abstract void handleMouseClick(int var1, int var2, int var3);

    public abstract void handleMouseDrag(int var1, int var2, int var3);

    public abstract void handleMouseRelease(int var1, int var2, int var3);

    public abstract void handleMouseScroll(int var1, int var2, boolean var3);

    public abstract String getWindowTitle();

    public abstract int getWidth();

    public abstract int getHeight();

    public abstract void markForLayoutUpdate();

    public abstract boolean isPendingLayoutUpdate();

    public abstract void clearPendingLayout();

    public abstract void updateComponents(int var1, int var2);

    public void onClose() {
    }

    public final void setWindow(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("You can't set a null window instance");
        }
        this.window = window;
    }

    public final Window getWindow() {
        return this.window;
    }

    public final void openDialog(Dialog dialog) {
        this.window.openDialog(dialog);
    }
}

