/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.io.drive;

import com.mrcrayfish.device.core.io.FileSystem;
import com.mrcrayfish.device.core.io.ServerFile;
import com.mrcrayfish.device.core.io.ServerFolder;
import com.mrcrayfish.device.core.io.action.FileAction;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public abstract class AbstractDrive {
    protected String name;
    protected UUID uuid;
    protected ServerFolder root;

    AbstractDrive() {
    }

    AbstractDrive(String name) {
        this.name = name;
        this.uuid = UUID.randomUUID();
        this.root = AbstractDrive.createProtectedFolder("Root");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public ServerFolder getRoot(World world) {
        return this.root;
    }

    public FileSystem.Response handleFileAction(FileSystem fileSystem, FileAction action, World world) {
        NBTTagCompound actionData = action.getData();
        ServerFolder folder = this.getFolder(actionData.func_74779_i("directory"));
        if (folder != null) {
            NBTTagCompound data = actionData.func_74775_l("data");
            switch (action.getType()) {
                case NEW: {
                    if (data.func_150297_b("files", 10)) {
                        return folder.add(ServerFolder.fromTag(actionData.func_74779_i("file_name"), data), actionData.func_74767_n("override"));
                    }
                    return folder.add(ServerFile.fromTag(actionData.func_74779_i("file_name"), data), data.func_74767_n("override"));
                }
                case DELETE: {
                    return folder.delete(actionData.func_74779_i("file_name"));
                }
                case RENAME: {
                    ServerFile file = folder.getFile(actionData.func_74779_i("file_name"));
                    if (file != null) {
                        return file.rename(actionData.func_74779_i("new_file_name"));
                    }
                    return FileSystem.createResponse(2, "File not found on server. Please refresh!");
                }
                case DATA: {
                    ServerFile file = folder.getFile(actionData.func_74779_i("file_name"));
                    if (file != null) {
                        return file.setData(actionData.func_74775_l("data"));
                    }
                    return FileSystem.createResponse(2, "File not found on server. Please refresh!");
                }
                case COPY_CUT: {
                    ServerFile file = folder.getFile(actionData.func_74779_i("file_name"));
                    if (file != null) {
                        UUID uuid = UUID.fromString(actionData.func_74779_i("destination_drive"));
                        AbstractDrive drive = fileSystem.getAvailableDrives(world, true).get(uuid);
                        if (drive != null) {
                            ServerFolder destination = drive.getFolder(actionData.func_74779_i("destination_folder"));
                            if (destination != null) {
                                for (ServerFolder temp = destination; temp != null; temp = temp.getParent()) {
                                    if (temp != file) continue;
                                    return FileSystem.createResponse(0, "Destination folder can't be a subfolder");
                                }
                                FileSystem.Response response = destination.add(file.copy(), actionData.func_74767_n("override"));
                                if (response.getStatus() != 1) {
                                    return response;
                                }
                                if (actionData.func_74767_n("cut")) {
                                    return file.delete();
                                }
                                return FileSystem.createSuccessResponse();
                            }
                            return FileSystem.createResponse(2, "Destination folder not found on server. Please refresh!");
                        }
                        return FileSystem.createResponse(7, "Drive unavailable. Please refresh!");
                    }
                    return FileSystem.createResponse(2, "File not found on server. Please refresh!");
                }
            }
        }
        return FileSystem.createResponse(7, "Invalid directory");
    }

    public abstract NBTTagCompound toTag();

    public abstract Type getType();

    @Nullable
    public ServerFolder getFolder(String path) {
        if (path == null) {
            throw new IllegalArgumentException("The path can not be null");
        }
        if (!FileSystem.PATTERN_DIRECTORY.matcher(path).matches()) {
            throw new IllegalArgumentException("The path \"" + path + "\" does not follow the correct format");
        }
        if (path.equals("/")) {
            return this.root;
        }
        ServerFolder prev = this.root;
        String[] folders = path.split("/");
        if (folders.length > 0 && folders.length <= 10) {
            for (int i = 1; i < folders.length; ++i) {
                ServerFolder temp = prev.getFolder(folders[i]);
                if (temp == null) {
                    return null;
                }
                prev = temp;
            }
            return prev;
        }
        return null;
    }

    public ServerFolder getDriveStructure() {
        return this.root.copyStructure();
    }

    private static ServerFolder createProtectedFolder(String name) {
        try {
            Constructor constructor = ServerFolder.class.getDeclaredConstructor(String.class, Boolean.TYPE);
            constructor.setAccessible(true);
            return (ServerFolder)constructor.newInstance(name, true);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static enum Type {
        INTERNAL,
        EXTERNAL,
        NETWORK;

    }
}

