/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.jei;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.device.init.DeviceBlocks;
import com.mrcrayfish.device.init.DeviceItems;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.wrapper.IShapedCraftingRecipeWrapper;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class LaptopRecipeWrapper
implements IShapedCraftingRecipeWrapper {
    private List<ItemStack> inputs;
    private List<ItemStack> outputs;

    public LaptopRecipeWrapper(EnumDyeColor color) {
        ItemStack motherboard = new ItemStack(DeviceItems.COMPONENT_MOTHERBOARD);
        NBTTagCompound tag = motherboard.func_190925_c("components");
        tag.func_74757_a("cpu", true);
        tag.func_74757_a("ram", true);
        tag.func_74757_a("gpu", true);
        tag.func_74757_a("wifi", true);
        ImmutableList.Builder input = ImmutableList.builder();
        input.add((Object)new ItemStack(DeviceItems.PLASTIC_FRAME));
        input.add((Object)new ItemStack(DeviceItems.COMPONENT_SCREEN));
        input.add((Object)new ItemStack(DeviceItems.PLASTIC_FRAME));
        input.add((Object)new ItemStack(DeviceItems.COMPONENT_BATTERY));
        input.add((Object)motherboard);
        input.add((Object)new ItemStack(DeviceItems.COMPONENT_HARD_DRIVE));
        input.add((Object)new ItemStack(DeviceItems.PLASTIC_FRAME));
        input.add((Object)new ItemStack(Items.field_151100_aR, 1, color.func_176767_b()));
        input.add((Object)new ItemStack(DeviceItems.PLASTIC_FRAME));
        this.inputs = input.build();
        ImmutableList.Builder output = ImmutableList.builder();
        output.add((Object)new ItemStack(DeviceBlocks.LAPTOP, 1, color.func_176765_a()));
        this.outputs = output.build();
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }
}

