/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.gitweb;

import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.app.Icons;
import com.mrcrayfish.device.api.app.Layout;
import com.mrcrayfish.device.api.app.component.Button;
import com.mrcrayfish.device.api.app.component.Spinner;
import com.mrcrayfish.device.api.app.component.TextField;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.programs.gitweb.component.GitWebFrame;
import com.mrcrayfish.device.programs.gitweb.layout.TextLayout;
import com.mrcrayfish.device.programs.system.layout.StandardLayout;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Gui;
import net.minecraft.nbt.NBTTagCompound;

public class ApplicationGitWeb
extends Application {
    private Layout layoutBrowser;
    private Layout layoutPref;
    private Button btnSearch;
    private Button btnHome;
    private Button btnSettings;
    private GitWebFrame webFrame;
    private TextField textFieldAddress;
    private Spinner spinnerLoading;
    private TextLayout scrollable;

    @Override
    public void init(@Nullable NBTTagCompound intent) {
        this.layoutBrowser = new StandardLayout("GitWeb", 362, 240, this, null);
        this.layoutBrowser.setBackground((gui, mc, x, y, width, height, mouseX, mouseY, windowActive) -> {
            Color color = new Color(Laptop.getSystem().getSettings().getColorScheme().getItemBackgroundColor());
            Gui.func_73734_a((int)x, (int)(y + 21), (int)(x + width), (int)(y + 164), (int)Color.GRAY.getRGB());
        });
        this.layoutPref = new Layout(200, 120);
        this.textFieldAddress = new TextField(2, 2, 304);
        this.textFieldAddress.setPlaceholder("Enter Address");
        this.textFieldAddress.setKeyListener(c -> {
            if (c == '\r') {
                this.webFrame.loadWebsite(this.getAddress());
                return false;
            }
            return true;
        });
        this.layoutBrowser.addComponent(this.textFieldAddress);
        this.spinnerLoading = new Spinner(291, 4);
        this.spinnerLoading.setVisible(false);
        this.layoutBrowser.addComponent(this.spinnerLoading);
        this.btnSearch = new Button(308, 2, 16, 16, Icons.ARROW_RIGHT);
        this.btnSearch.setToolTip("Refresh", "Loads the entered address.");
        this.btnSearch.setClickListener((mouseX, mouseY, mouseButton) -> this.webFrame.loadWebsite(this.getAddress()));
        this.layoutBrowser.addComponent(this.btnSearch);
        this.btnHome = new Button(326, 2, 16, 16, Icons.HOME);
        this.btnHome.setToolTip("Home", "Loads page set in settings.");
        this.btnHome.setClickListener((mouseX, mouseY, mouseButton) -> this.webFrame.loadWebsite("welcome.official"));
        this.layoutBrowser.addComponent(this.btnHome);
        this.btnSettings = new Button(344, 2, 16, 16, Icons.WRENCH);
        this.btnSettings.setToolTip("Settings", "Change your preferences.");
        this.btnSettings.setClickListener((mouseX, mouseY, mouseButton) -> this.setCurrentLayout(this.layoutPref));
        this.layoutBrowser.addComponent(this.btnSettings);
        this.webFrame = new GitWebFrame(this, 0, 21, 362, 143);
        this.webFrame.loadWebsite("welcome.official");
        this.webFrame.setLoadingCallback((s, success) -> {
            this.spinnerLoading.setVisible(true);
            this.textFieldAddress.setFocused(false);
            this.textFieldAddress.setEditable(false);
            this.textFieldAddress.setText((String)s);
            this.btnSearch.setEnabled(false);
        });
        this.webFrame.setLoadedCallback((s, success) -> {
            this.spinnerLoading.setVisible(false);
            this.textFieldAddress.setEditable(true);
            this.btnSearch.setEnabled(true);
        });
        this.layoutBrowser.addComponent(this.webFrame);
        this.setCurrentLayout(this.layoutBrowser);
    }

    @Override
    public void handleKeyTyped(char character, int code) {
        super.handleKeyTyped(character, code);
    }

    private String getAddress() {
        return this.textFieldAddress.getText().replace("\\s+", "");
    }

    @Override
    public void load(NBTTagCompound tag) {
    }

    @Override
    public void save(NBTTagCompound tag) {
    }
}

