/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.programs.system.task;

import com.mrcrayfish.device.api.task.Task;
import com.mrcrayfish.device.api.utils.BankUtil;
import com.mrcrayfish.device.programs.system.object.Account;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TaskWithdraw
extends Task {
    private int amount;

    private TaskWithdraw() {
        super("bank_withdraw");
    }

    public TaskWithdraw(int amount) {
        this();
        this.amount = amount;
    }

    @Override
    public void prepareRequest(NBTTagCompound nbt) {
        nbt.func_74768_a("amount", this.amount);
    }

    @Override
    public void processRequest(NBTTagCompound nbt, World world, EntityPlayer player) {
        int amount = nbt.func_74762_e("amount");
        Account account = BankUtil.INSTANCE.getAccount(player);
        if (account.withdraw(amount)) {
            int stacks = amount / 64;
            for (int i = 0; i < stacks; ++i) {
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(Items.field_151166_bC, 64)));
            }
            int remaining = amount % 64;
            if (remaining > 0) {
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(Items.field_151166_bC, remaining)));
            }
            this.amount = account.getBalance();
            this.setSuccessful();
        }
    }

    @Override
    public void prepareResponse(NBTTagCompound nbt) {
        nbt.func_74768_a("balance", this.amount);
    }

    @Override
    public void processResponse(NBTTagCompound nbt) {
    }
}

