/*
 * Decompiled with CFR 0.152.
 */
package cubex2.ttfr;

import cubex2.ttfr.Glyph;
import cubex2.ttfr.GlyphCache;
import cubex2.ttfr.StringCache;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class StringRenderer {
    private static final int BASELINE_OFFSET = 7;
    private static final int UNDERLINE_OFFSET = 1;
    private static final int UNDERLINE_THICKNESS = 2;
    private static final int STRIKETHROUGH_OFFSET = -6;
    private static final int STRIKETHROUGH_THICKNESS = 2;
    private final StringCache cache;
    private int[] colorTable;

    StringRenderer(StringCache cache, int[] colors) {
        this.cache = cache;
        this.colorTable = colors;
    }

    StringCache getCache() {
        return this.cache;
    }

    public int renderString(String str, float startX, float startY, int initialColor, boolean shadowFlag) {
        if (str == null || str.isEmpty()) {
            return 0;
        }
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)8448);
        StringCache.Entry entry = this.cache.cacheString(str);
        startY += 7.0f;
        int color = initialColor;
        GlStateManager.func_179124_c((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f));
        if (this.cache.antiAliasEnabled) {
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        byte fontStyle = 0;
        int colorIndex = 0;
        for (int glyphIndex = 0; glyphIndex < entry.glyphs.length; ++glyphIndex) {
            while (colorIndex < entry.colors.length && entry.glyphs[glyphIndex].stringIndex >= entry.colors[colorIndex].stringIndex) {
                color = this.applyColorCode(entry.colors[colorIndex].colorCode, initialColor, shadowFlag);
                fontStyle = entry.colors[colorIndex].fontStyle;
                ++colorIndex;
            }
            Glyph glyph = entry.glyphs[glyphIndex];
            GlyphCache.Entry texture = glyph.texture;
            int glyphX = glyph.x;
            char c = str.charAt(glyph.stringIndex);
            if (c >= '0' && c <= '9') {
                int oldWidth = texture.width;
                texture = this.cache.digitGlyphs[fontStyle][c - 48].texture;
                int newWidth = texture.width;
                glyphX += oldWidth - newWidth >> 1;
            }
            float x1 = startX + (float)glyphX / 2.0f;
            float x2 = startX + (float)(glyphX + texture.width) / 2.0f;
            float y1 = startY + (float)glyph.y / 2.0f;
            float y2 = startY + (float)(glyph.y + texture.height) / 2.0f;
            int a = color >> 24 & 0xFF;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            GlStateManager.func_179144_i((int)texture.textureName);
            buffer.func_181662_b((double)x1, (double)y1, 0.0).func_187315_a((double)texture.u1, (double)texture.v1).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x1, (double)y2, 0.0).func_187315_a((double)texture.u1, (double)texture.v2).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x2, (double)y2, 0.0).func_187315_a((double)texture.u2, (double)texture.v2).func_181669_b(r, g, b, a).func_181675_d();
            buffer.func_181662_b((double)x2, (double)y1, 0.0).func_187315_a((double)texture.u2, (double)texture.v1).func_181669_b(r, g, b, a).func_181675_d();
            tessellator.func_78381_a();
        }
        if (entry.specialRender) {
            byte renderStyle = 0;
            color = initialColor;
            GlStateManager.func_179090_x();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            int colorIndex2 = 0;
            for (int glyphIndex = 0; glyphIndex < entry.glyphs.length; ++glyphIndex) {
                float y2;
                float y1;
                float x2;
                float x1;
                while (colorIndex2 < entry.colors.length && entry.glyphs[glyphIndex].stringIndex >= entry.colors[colorIndex2].stringIndex) {
                    color = this.applyColorCode(entry.colors[colorIndex2].colorCode, initialColor, shadowFlag);
                    renderStyle = entry.colors[colorIndex2].renderStyle;
                    ++colorIndex2;
                }
                Glyph glyph = entry.glyphs[glyphIndex];
                int glyphSpace = glyph.advance - glyph.texture.width;
                int a = color >> 24 & 0xFF;
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                if ((renderStyle & 1) != 0) {
                    x1 = startX + (float)(glyph.x - glyphSpace) / 2.0f;
                    x2 = startX + (float)(glyph.x + glyph.advance) / 2.0f;
                    y1 = startY + 0.5f;
                    y2 = startY + 1.5f;
                    buffer.func_181662_b((double)x1, (double)y1, 0.0).func_181669_b(r, g, b, a).func_181675_d();
                    buffer.func_181662_b((double)x1, (double)y2, 0.0).func_181669_b(r, g, b, a).func_181675_d();
                    buffer.func_181662_b((double)x2, (double)y2, 0.0).func_181669_b(r, g, b, a).func_181675_d();
                    buffer.func_181662_b((double)x2, (double)y1, 0.0).func_181669_b(r, g, b, a).func_181675_d();
                }
                if ((renderStyle & 2) == 0) continue;
                x1 = startX + (float)(glyph.x - glyphSpace) / 2.0f;
                x2 = startX + (float)(glyph.x + glyph.advance) / 2.0f;
                y1 = startY + -3.0f;
                y2 = startY + -2.0f;
                buffer.func_181662_b((double)x1, (double)y1, 0.0).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b((double)x1, (double)y2, 0.0).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b((double)x2, (double)y2, 0.0).func_181669_b(r, g, b, a).func_181675_d();
                buffer.func_181662_b((double)x2, (double)y1, 0.0).func_181669_b(r, g, b, a).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179098_w();
        }
        return entry.advance / 2;
    }

    public int getStringWidth(String str) {
        if (str == null || str.isEmpty()) {
            return 0;
        }
        StringCache.Entry entry = this.cache.cacheString(str);
        return entry.advance / 2;
    }

    private int sizeString(String str, int width, boolean breakAtSpaces) {
        int index;
        if (str == null || str.isEmpty()) {
            return 0;
        }
        width = width >= 0x3FFFFFFF ? Integer.MAX_VALUE : (width += width);
        Glyph[] glyphs = this.cache.cacheString((String)str).glyphs;
        int wsIndex = -1;
        int advance = 0;
        for (index = 0; index < glyphs.length && advance <= width; ++index) {
            int nextAdvance;
            if (breakAtSpaces) {
                char c = str.charAt(glyphs[index].stringIndex);
                if (c == ' ') {
                    wsIndex = index;
                } else if (c == '\n') {
                    wsIndex = index;
                    break;
                }
            }
            if ((nextAdvance = advance + glyphs[index].advance) > width) break;
            advance = nextAdvance;
        }
        if (index < glyphs.length && wsIndex != -1 && wsIndex < index) {
            index = wsIndex;
        }
        return index < glyphs.length ? glyphs[index].stringIndex : str.length();
    }

    public int sizeStringToWidth(String str, int width) {
        return this.sizeString(str, width, true);
    }

    public String trimStringToWidth(String str, int width, boolean reverse) {
        if (reverse) {
            str = new StringBuilder(str).reverse().toString();
        }
        int length = this.sizeString(str, width, true);
        str = str.substring(0, length);
        if (reverse) {
            str = new StringBuilder(str).reverse().toString();
        }
        return str;
    }

    private int applyColorCode(int colorCode, int color, boolean shadowFlag) {
        if (colorCode != -1) {
            colorCode = shadowFlag ? colorCode + 16 : colorCode;
            color = this.colorTable[colorCode] & 0xFFFFFF | color & 0xFF000000;
        }
        return color;
    }
}

